
// MARK: level meter functions

// function to add a mixer track with track index set
// baseMarkup -> "BlockMixerTrack" or "PopoverMixerTrack"
function meterLabel(labelText, layoutOffset)
{
	return {
		nsClass: "GXDrawView",
		gxLayout:
		[
			"H:|-22-[self]-22-|",
			"V:|-" + layoutOffset + "-[self(12)]",

			"V:|-1-[dbLabel]",
			
			"V:|-7-[leftLine(1)]",
			"V:|-7-[rightLine(1)]",
		 
			"H:|-6-[leftLine(28)]-4-[dbLabel]-4-[rightLine(28)]-6-|",
		],
		gxChildViews:
		{
			dbLabel: labelView(labelText, "top.centerx.size9"),
			leftLine: fineHLineView("ForeColor2"),
			rightLine: fineHLineView("ForeColor2"),
		},
	};
}

function blockMeterLabel(labelText, layoutOffset)
{
	return {
		nsClass: "GXDrawView",
		gxLayout:
		[
			"H:|-26-[self]-26-|",
			"V:|-" + layoutOffset + "-[self(12)]",

			"V:|-1-[dbLabel]",
			
			"V:|-7-[leftLine(1)]",
			"V:|-7-[rightLine(1)]",
		 
			"H:|-0-[leftLine(15)]-4-[dbLabel]-4-[rightLine(15)]-0-|",
		],
		gxChildViews:
		{
			dbLabel: labelView(labelText, "top.centerx.foreColorTheme1.size9"),
			leftLine: fineHLineView("ForeColorTheme1"),
			rightLine: fineHLineView("ForeColorTheme1"),
		},
	};
}

function fineHLineView(color)
{
	return {
		nsClass: "GXDrawView",
		gxBackPainter: {
			nsClass: "GXPainter",
			gxFillColor: color,
			gxEdgeInsets: "0, 0, 0, 0.5",	// inset on one side of height to get 0.5pt line
		}
	};
}


// ------------------------------------------------------


markup.push({

	// MARK: - meter colors
	
	PeakMeterColor: colorHSBA(42, 50, 100, 100),
	RMSMeterColor: colorHSBA(38, 100, 100, 100),
	HoldMeterColor: colorHSBA(38, 10, 100, 100),
	ClipMeterColor: colorHSBA(6, 80, 100, 100),
	MenuBackMeterColor: colorMono(60, 80),

	// MARK: - meter layer templates
	
	MeterLayer:
	{
		nsClass: "AH4MeterLayer",
		gxAnimateOnKey: "meterAnimating",
		gxMaskLayer: {
			nsClass: "GXDrawLayer",
			menubar: {
				gxBackPainter: roundRectPainter("BlackColor", 2.5),
			},
			blockface: {
				gxBackPainter: roundRectPainter("BlackColor", 5),
			},
			gxBackPainter: roundRectPainter("BlackColor", 5.5),
			rounded: {
				gxBackPainter: roundRectPainter("BlackColor", 999),
			},
		},
	},

	PeakLayer: {
		"+": "MeterLayer",
		gxLayerZPosition: 1,
		gxForePainter: fillPainter("PeakMeterColor"),
		// peak is also background for meter
		blockface: { gxBackPainter: fillPainter("ColorTheme2") },
		gxBackPainter: fillPainter("BackColor3"),
		menubar: { gxBackPainter: fillPainter("MenuBackMeterColor") },
	},
	
	RMSLayer: {
		"+": "MeterLayer",
		gxLayerZPosition: 2,
		gxForePainter: fillPainter("RMSMeterColor"),
	},

	ClipLayer: {
		"+": "MeterLayer",
		gxLayerZPosition: 4,
		gxForePainter: fillPainter("ClipMeterColor"),
		blockface: { gxBackPainter: fillPainter("ColorTheme2") },
		gxBackPainter: fillPainter("BackColor3"),
		menubar: { gxBackPainter: fillPainter("MenuBackMeterColor") },
	},
	
	HoldLayer: {
		"+": "MeterLayer",
		gxLayerZPosition: 4,
		gxForePainter: fillPainter("HoldMeterColor"),
	},


	// MARK: - level meter block

	LevelMeterBlock:
    {
		"+": "BlockTemplate",
		geNodeClass: "AHLevelMetersNode",
		gxMenuBarView: "LevelMeterStatusItem",
		gxTitle: "Peak/RMS",
		gxLibraryDisplayName: "Peak/RMS Meters",
		gxPopoverInfo: "LevelMeterPopover",
		gxLibraryDescription: "View a calibrated level meter",
		gxLibraryIcon: "library.meter.level",
		gxChildViews:
		{
			layerHostView:
			{
				nsClass: "GXLayerHostingView",
				gxLayerZPosition: 2,
				gxEdgeInsets: "1, 1, 1, 1",
				gxLayout: [
						   
					// note calibration of markings can be easily broken by layout!
						   
					"H:|-24-[self]-24-|",
					"V:|-31-[self]-9-|",

					"V:|-4-[leftClip(9)]-4-[leftPeak]-4-|",
					"V:[leftClip]-4-[leftRMS]-4-|",
				    "V:[leftClip]-4-[leftHold]-4-|",
						   
					"H:|-5-[leftPeak(9)]",
					"H:|-5-[leftRMS(9)]",
				    "H:|-5-[leftHold(9)]",
				   	"H:|-5-[leftClip(9)]",

					"V:|-4-[rightClip(9)]-4-[rightPeak]-4-|",
					"V:[rightClip]-4-[rightRMS]-4-|",
					"V:[rightClip]-4-[rightHold]-4-|",
					
					"H:[rightPeak(9)]-5-|",
					"H:[rightRMS(9)]-5-|",
					"H:[rightHold(9)]-5-|",
					"H:[rightClip(9)]-5-|",
				],
				gxRootLayer:
				{
					nsClass: "GXDrawLayer",
					gxLayerZPosition: 10,
					gxViewModel: { nsClass: "AH4LevelMeterVModel" },
					gxSublayers:
					{
						leftPeak: { "+": "PeakLayer.blockface" },
						leftRMS: { "+": "RMSLayer.blockface" },
						leftClip: { "+": "ClipLayer.blockface" },
						leftHold: { "+": "HoldLayer.blockface" },

						rightPeak: { "+": "PeakLayer.blockface" },
						rightRMS: { "+": "RMSLayer.blockface" },
						rightClip: { "+": "ClipLayer.blockface" },
						rightHold: { "+": "HoldLayer.blockface" },
					}
				}
			},
			
			// note calibration of markings can be easily broken by layout!
			label1: blockMeterLabel("-3dB", 	49),
			label2: blockMeterLabel("-9dB", 	61),
			label3: blockMeterLabel("-18dB", 	74),
			label4: blockMeterLabel("-36dB", 	89),
		}
	},

    
	// MARK: - menu bar meter

	LevelMeterStatusItem:
	{
		nsClass: "GXMenuBarView",
		gxLayout:
		[
			"V:|-0-[self(23)]-0-|",
		 	"H:|-3-[self(45)]-3-|",
		],
		gxChildViews:
		{
			layerHostView:
			{
				nsClass: "GXLayerHostingView",
				gxLayout: [
					"H:|-0-[self]-0-|",
					"V:|-0-[self]-0-|",

					"H:|-0-[leftPeakH]-2-[leftClip(5)]-0-|",
					"H:|-0-[leftRMSH]-2-[leftClip]",
				    "H:|-0-[leftHoldH]-2-[leftClip]",

					"V:|-5-[leftPeakH(5)]",
					"V:|-5-[leftRMSH(5)]",
				    "V:|-5-[leftHoldH(5)]",
				   	"V:|-5-[leftClip(5)]",

					"H:|-0-[rightPeakH]-2-[rightClip(5)]-0-|",
					"H:|-0-[rightRMSH]-2-[rightClip]",
				    "H:|-0-[rightHoldH]-2-[rightClip]",

					"V:|-15-[rightPeakH(5)]",
					"V:|-15-[rightRMSH(5)]",
				    "V:|-15-[rightHoldH(5)]",
				   	"V:|-15-[rightClip(5)]",
				],
				gxRootLayer:
				{
					nsClass: "GXDrawLayer",
					gxViewModel: { nsClass: "AH4LevelMeterVModel" },
					gxSublayers:
					{
						leftPeakH: { "+": "PeakLayer.menubar" },
						leftRMSH: { "+": "RMSLayer.menubar" },
						leftClip: { "+": "ClipLayer.menubar" },
						leftHoldH: { "+": "HoldLayer.menubar" },
						
						rightPeakH: { "+": "PeakLayer.menubar" },
						rightRMSH: { "+": "RMSLayer.menubar" },
						rightClip: { "+": "ClipLayer.menubar" },
						rightHoldH: { "+": "HoldLayer.menubar" },
					}
				}
			},
		}
	},

	
	// MARK: - level meter popover

	LevelMeterPopover:
	{
		"+": "PopoverTemplate",
		gxWantsLayer: true,
		gxCanDrawSubviewsIntoLayer: true,
		gxLayout: [
			"H:|-12-[self]-12-|",
			"V:|-12-[self]-12-|",

			"H:|-0-[group]-0-|",
			"V:|-41-[group]-10-[showInMenubar]-14-|",

			"H:|-12-[showInMenubar(138)]-12-|",	// this sets width. text just fits.
		],
		gxChildViews:
		{
			onOff: "PopoverOnOffSwitch",
			showInMenubar:
			{
				"+": "CheckboxTemplate",
				//gxTitle: "<checkbox/> Show in\n<checkboxSpacer/> menu bar",
                gxTitle: "<checkbox/> Show in menu bar",
				gxValueKey: "showMenuItem",
			},
			group: {
				"+": "GroupView",
				gxLayout:
				[
					"H:|-16-[layerHostView]-16-|",
					"V:|-12-[layerHostView]-4-[leftLabel]-8-|",
						   
					"H:|-10-[leftLabel]-10-[rightLabel(==leftLabel)]-10-|&alignBaseline",
				],
				gxChildViews:
				{
					layerHostView:
					{
						nsClass: "GXLayerHostingView",
						gxEdgeInsets: "1, 1, 1, 1",
						gxLayout: [

							"V:|-0-[leftClip(10)]-4-[leftPeak(330)]-0-|",	// sets height
							"V:[leftClip]-4-[leftRMS]-0-|",
							"V:[leftClip]-4-[leftHold]-0-|",
							
							"H:|-17-[leftRMS(18)]",
							"H:|-17-[leftPeak(18)]",
							"H:|-17-[leftHold(18)]",
							"H:|-17-[leftClip(18)]",

							"V:|-0-[rightClip(10)]-4-[rightPeak]-0-|",
							"V:[rightClip]-4-[rightRMS]-0-|",
							"V:[rightClip]-4-[rightHold]-0-|",

							"H:[rightPeak(18)]-17-|",
							"H:[rightRMS(18)]-17-|",
							"H:[rightHold(18)]-17-|",
							"H:[rightClip(18)]-17-|",
						],
						gxRootLayer:
						{
							nsClass: "GXDrawLayer",
							gxViewModel: { nsClass: "AH4LevelMeterVModel" },
							gxSublayers:
							{
								leftPeak: { "+": "PeakLayer" },
								leftRMS: { "+": "RMSLayer" },
								leftClip: { "+": "ClipLayer" },
								leftHold: { "+": "HoldLayer" },
								
								rightPeak: { "+": "PeakLayer" },
								rightRMS: { "+": "RMSLayer" },
								rightClip: { "+": "ClipLayer" },
								rightHold: { "+": "HoldLayer" },
							}
						}
					},
					
					db0: 	meterLabel(	" 0dB", 	21 + 0),
					db1: 	meterLabel(	"-1dB", 	21 + 15),
					db3: 	meterLabel(	"-3dB", 	21 + 42),
					db6: 	meterLabel(	"-6dB", 	21 + 79),
					db9: 	meterLabel(	"-9dB", 	21 + 111),
					db12: 	meterLabel(	"-12dB", 	21 + 139),
					db18: 	meterLabel(	"-18dB", 	21 + 184),
					db24: 	meterLabel(	"-24dB", 	21 + 219),
					db30: 	meterLabel(	"-30dB", 	21 + 246),
					db36: 	meterLabel(	"-36dB", 	21 + 266),
					db48: 	meterLabel(	"-48dB", 	21 + 294),
					db60: 	meterLabel(	"-60dB", 	21 + 310),
					
					leftLabel: labelView("Left", "centerx"),
					rightLabel: labelView("Right", "centerx"),
				},
			},
		},
	},


})
